/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mrcrayfish.framework.network.message.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import ttv.migami.jeg.blockentity.GunmetalWorkbenchBlockEntity;
import ttv.migami.jeg.client.screen.CheckBox;
import ttv.migami.jeg.client.util.RenderUtil;
import ttv.migami.jeg.common.NetworkGunManager;
import ttv.migami.jeg.common.container.GunmetalWorkbenchContainer;
import ttv.migami.jeg.crafting.GunmetalWorkbenchRecipe;
import ttv.migami.jeg.crafting.GunmetalWorkbenchRecipes;
import ttv.migami.jeg.crafting.ScrapWorkbenchIngredient;
import ttv.migami.jeg.init.ModBlocks;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.IAmmo;
import ttv.migami.jeg.item.IColored;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageCraft;
import ttv.migami.jeg.util.InventoryUtil;

public class GunmetalWorkbenchScreen
extends AbstractContainerScreen<GunmetalWorkbenchContainer> {
    private static final ResourceLocation GUI_BASE = new ResourceLocation("jeg:textures/gui/workbench.png");
    private static boolean showRemaining = false;
    private Tab currentTab;
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private final Inventory playerInventory;
    private final GunmetalWorkbenchBlockEntity workbench;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private ItemStack displayStack;

    public GunmetalWorkbenchScreen(GunmetalWorkbenchContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workbench = container.getWorkbench();
        this.f_97726_ = 275;
        this.f_97727_ = 184;
        this.materials = new ArrayList<MaterialItem>();
        this.createTabs(GunmetalWorkbenchRecipes.getAll(playerInventory.f_35978_.f_19853_));
        if (!this.tabs.isEmpty()) {
            this.f_97727_ += 28;
        }
    }

    private void createTabs(NonNullList<GunmetalWorkbenchRecipe> recipes) {
        ItemStack icon;
        ArrayList<GunmetalWorkbenchRecipe> weapons = new ArrayList<GunmetalWorkbenchRecipe>();
        ArrayList<GunmetalWorkbenchRecipe> attachments = new ArrayList<GunmetalWorkbenchRecipe>();
        ArrayList<GunmetalWorkbenchRecipe> ammo = new ArrayList<GunmetalWorkbenchRecipe>();
        ArrayList<GunmetalWorkbenchRecipe> stations = new ArrayList<GunmetalWorkbenchRecipe>();
        ArrayList<GunmetalWorkbenchRecipe> misc = new ArrayList<GunmetalWorkbenchRecipe>();
        for (GunmetalWorkbenchRecipe recipe : recipes) {
            ItemStack output = recipe.getItem();
            if (output.m_41720_() instanceof GunItem) {
                weapons.add(recipe);
                continue;
            }
            if (output.m_41720_() instanceof IAttachment) {
                attachments.add(recipe);
                continue;
            }
            if (this.isAmmo(output)) {
                ammo.add(recipe);
                continue;
            }
            if (output.m_41720_() instanceof BlockItem) {
                stations.add(recipe);
                continue;
            }
            misc.add(recipe);
        }
        if (!weapons.isEmpty()) {
            icon = new ItemStack((ItemLike)ModItems.ASSAULT_RIFLE.get());
            icon.m_41784_().m_128405_("AmmoCount", ((GunItem)ModItems.ASSAULT_RIFLE.get()).getGun().getReloads().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons", weapons));
        }
        if (!attachments.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)ModItems.HOLOGRAPHIC_SIGHT.get()), "attachments", attachments));
        }
        if (!ammo.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)ModItems.RIFLE_AMMO.get()), "ammo", ammo));
        }
        if (!stations.isEmpty()) {
            icon = new ItemStack((ItemLike)ModBlocks.GUNMETAL_WORKBENCH.get());
            this.tabs.add(new Tab(icon, "stations", stations));
        }
        if (!misc.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((ItemLike)ModItems.SCRAP.get()), "misc", misc));
        }
        if (!this.tabs.isEmpty()) {
            this.currentTab = this.tabs.get(0);
        }
    }

    private boolean isAmmo(ItemStack stack) {
        if (stack.m_41720_() instanceof IAmmo) {
            return true;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        Objects.requireNonNull(id);
        for (GunItem gunItem : NetworkGunManager.getClientRegisteredGuns()) {
            if (!id.equals((Object)gunItem.getModifiedGun(stack).getProjectile().getItem())) continue;
            return true;
        }
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        if (!this.tabs.isEmpty()) {
            this.f_97736_ += 28;
        }
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 9, this.f_97736_ + 18, 15, 20, (Component)Component.m_237113_((String)"<"), button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index - 1 < 0) {
                this.loadItem(this.currentTab.getRecipes().size() - 1);
            } else {
                this.loadItem(index - 1);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 153, this.f_97736_ + 18, 15, 20, (Component)Component.m_237113_((String)">"), button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index + 1 >= this.currentTab.getRecipes().size()) {
                this.loadItem(0);
            } else {
                this.loadItem(index + 1);
            }
        }));
        this.btnCraft = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 195, this.f_97736_ + 16, 74, 20, (Component)Component.m_237115_((String)"gui.jeg.workbench.assemble"), button -> {
            int index = this.currentTab.getCurrentIndex();
            GunmetalWorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
            ResourceLocation registryName = recipe.m_6423_();
            PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageCraft(registryName, this.workbench.m_58899_()));
        }));
        this.btnCraft.f_93623_ = false;
        this.checkBoxMaterials = (CheckBox)this.m_142416_((GuiEventListener)new CheckBox(this.f_97735_ + 172, this.f_97736_ + 51, (Component)Component.m_237115_((String)"gui.jeg.workbench.show_remaining")));
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadItem(this.currentTab.getCurrentIndex());
    }

    public void m_181908_() {
        super.m_181908_();
        for (MaterialItem material : this.materials) {
            material.tick();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        this.btnCraft.f_93623_ = canCraft;
        this.updateColor();
    }

    private void updateColor() {
        ItemStack item;
        if (this.currentTab != null && IColored.isDyeable(item = this.displayStack)) {
            IColored colored = (IColored)item.m_41720_();
            if (!this.workbench.m_8020_(0).m_41619_()) {
                ItemStack dyeStack = this.workbench.m_8020_(0);
                if (dyeStack.m_41720_() instanceof DyeItem) {
                    DyeColor color = ((DyeItem)dyeStack.m_41720_()).m_41089_();
                    float[] components = color.m_41068_();
                    int red = (int)(components[0] * 255.0f);
                    int green = (int)(components[1] * 255.0f);
                    int blue = (int)(components[2] * 255.0f);
                    colored.setColor(item, (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
                } else {
                    colored.removeColor(item);
                }
            } else {
                colored.removeColor(item);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.m_6375_(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, this.f_97735_ + 28 * i, this.f_97736_ - 28, 28, 28)) continue;
            this.currentTab = this.tabs.get(i);
            this.loadItem(this.currentTab.getCurrentIndex());
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return result;
    }

    private void loadItem(int index) {
        GunmetalWorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
        this.displayStack = recipe.getItem().m_41777_();
        this.updateColor();
        this.materials.clear();
        ImmutableList<ScrapWorkbenchIngredient> ingredients = recipe.getMaterials();
        if (ingredients != null) {
            for (ScrapWorkbenchIngredient ingredient : ingredients) {
                MaterialItem item = new MaterialItem(ingredient);
                item.updateEnabledState();
                this.materials.add(item);
            }
            this.currentTab.setCurrentIndex(index);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        for (i = 0; i < this.tabs.size(); ++i) {
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, startX + 28 * i, startY - 28, 28, 28)) continue;
            this.m_96602_(poseStack, (Component)Component.m_237115_((String)this.tabs.get(i).getTabKey()), mouseX, mouseY);
            return;
        }
        for (i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 172;
            int itemY = startY + i * 19 + 63;
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)) == MaterialItem.EMPTY) continue;
            this.m_6057_(poseStack, materialItem.getDisplayStack(), mouseX, mouseY);
            return;
        }
        if (RenderUtil.isMouseWithin(mouseX, mouseY, startX + 8, startY + 38, 160, 48)) {
            this.m_6057_(poseStack, this.displayStack, mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        int offset = this.tabs.isEmpty() ? 0 : 28;
        this.f_96547_.m_92889_(poseStack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_ - 28.0f + (float)offset, 0x404040);
        this.f_96547_.m_92889_(poseStack, this.playerInventory.m_5446_(), (float)this.f_97730_, (float)this.f_97731_ - 9.0f + (float)offset, 0x404040);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        int i;
        partialTicks = Minecraft.m_91087_().m_91296_();
        int startX = this.f_97735_;
        int startY = this.f_97736_;
        RenderSystem.m_69478_();
        for (i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (tab == this.currentTab) continue;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
            this.m_93228_(poseStack, startX + 28 * i, startY - 28, 80, 184, 28, 32);
            Minecraft.m_91087_().m_91291_().m_115203_(tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
            Minecraft.m_91087_().m_91291_().m_115174_(this.f_96547_, tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8, null);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
        this.m_93228_(poseStack, startX, startY, 0, 0, 173, 184);
        GunmetalWorkbenchScreen.m_93160_((PoseStack)poseStack, (int)(startX + 173), (int)startY, (int)78, (int)184, (float)173.0f, (float)0.0f, (int)1, (int)184, (int)256, (int)256);
        this.m_93228_(poseStack, startX + 251, startY, 174, 0, 24, 184);
        this.m_93228_(poseStack, startX + 172, startY + 16, 198, 0, 20, 20);
        if (this.currentTab != null) {
            i = this.tabs.indexOf(this.currentTab);
            int u = i == 0 ? 80 : 108;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
            this.m_93228_(poseStack, startX + 28 * i, startY - 28, u, 214, 28, 32);
            Minecraft.m_91087_().m_91291_().m_115203_(this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
            Minecraft.m_91087_().m_91291_().m_115174_(this.f_96547_, this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8, null);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
        if (this.workbench.m_8020_(0).m_41619_()) {
            this.m_93228_(poseStack, startX + 174, startY + 18, 165, 199, 16, 16);
        }
        ItemStack currentItem = this.displayStack;
        StringBuilder builder = new StringBuilder(currentItem.m_41786_().getString());
        if (currentItem.m_41613_() > 1) {
            builder.append(ChatFormatting.GOLD);
            builder.append(ChatFormatting.BOLD);
            builder.append(" x ");
            builder.append(currentItem.m_41613_());
        }
        GunmetalWorkbenchScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)builder.toString(), (int)(startX + 88), (int)(startY + 22), (int)Color.WHITE.getRGB());
        GL11.glEnable((int)3089);
        RenderUtil.scissor(startX + 8, startY + 17, 160, 70);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)(startX + 88), (double)(startY + 60), 100.0);
        modelViewStack.m_85841_(50.0f, -50.0f, 50.0f);
        modelViewStack.m_85845_(Vector3f.f_122223_.m_122240_(5.0f));
        modelViewStack.m_85845_(Vector3f.f_122225_.m_122240_((float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks));
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource buffer = this.f_96541_.m_91269_().m_110104_();
        Minecraft.m_91087_().m_91291_().m_115143_(currentItem, ItemTransforms.TransformType.FIXED, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, RenderUtil.getModel(currentItem));
        buffer.m_109911_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        GL11.glDisable((int)3089);
        this.filteredMaterials = this.getMaterials();
        for (int i2 = 0; i2 < this.filteredMaterials.size(); ++i2) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BASE);
            MaterialItem materialItem = this.filteredMaterials.get(i2);
            ItemStack stack = materialItem.getDisplayStack();
            if (stack.m_41619_()) continue;
            Lighting.m_84930_();
            if (materialItem.isEnabled()) {
                this.m_93228_(poseStack, startX + 172, startY + i2 * 19 + 63, 0, 184, 80, 19);
            } else {
                this.m_93228_(poseStack, startX + 172, startY + i2 * 19 + 63, 0, 222, 80, 19);
            }
            Object name = stack.m_41786_().getString();
            if (this.f_96547_.m_92895_((String)name) > 55) {
                name = this.f_96547_.m_92834_((String)name, 50).trim() + "...";
            }
            this.f_96547_.m_92883_(poseStack, (String)name, (float)(startX + 172 + 22), (float)(startY + i2 * 19 + 6 + 63), Color.WHITE.getRGB());
            Minecraft.m_91087_().m_91291_().m_115203_(stack, startX + 172 + 2, startY + i2 * 19 + 1 + 63);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((Player)Minecraft.m_91087_().f_91074_, stack);
                stack = stack.m_41777_();
                stack.m_41764_(stack.m_41613_() - count);
            }
            Minecraft.m_91087_().m_91291_().m_115174_(this.f_96547_, stack, startX + 172 + 2, startY + i2 * 19 + 1 + 63, null);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.m_122780_((int)6, (Object)MaterialItem.EMPTY);
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : materialItem != MaterialItem.EMPTY).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, (MaterialItem)filteredMaterials.get(i));
        }
        return materials;
    }

    public List<Tab> getTabs() {
        return ImmutableList.copyOf(this.tabs);
    }

    private static class Tab {
        private final ItemStack icon;
        private final String id;
        private final List<GunmetalWorkbenchRecipe> items;
        private int currentIndex;

        public Tab(ItemStack icon, String id, List<GunmetalWorkbenchRecipe> items) {
            this.icon = icon;
            this.id = id;
            this.items = items;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public String getTabKey() {
            return "gui.jeg.workbench.tab." + this.id;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public List<GunmetalWorkbenchRecipe> getRecipes() {
            return this.items;
        }
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private long lastTime = System.currentTimeMillis();
        private int displayIndex;
        private boolean enabled = false;
        private ScrapWorkbenchIngredient ingredient;
        private final List<ItemStack> displayStacks = new ArrayList<ItemStack>();

        private MaterialItem() {
        }

        private MaterialItem(ScrapWorkbenchIngredient ingredient) {
            this.ingredient = ingredient;
            Stream.of(ingredient.m_43908_()).forEach(stack -> {
                ItemStack displayStack = stack.m_41777_();
                displayStack.m_41764_(ingredient.getCount());
                this.displayStacks.add(displayStack);
            });
        }

        public ScrapWorkbenchIngredient getIngredient() {
            return this.ingredient;
        }

        public void tick() {
            if (this.ingredient == null) {
                return;
            }
            this.updateEnabledState();
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTime >= 1000L) {
                this.displayIndex = (this.displayIndex + 1) % this.displayStacks.size();
                this.lastTime = currentTime;
            }
        }

        public ItemStack getDisplayStack() {
            return this.ingredient != null ? this.displayStacks.get(this.displayIndex) : ItemStack.f_41583_;
        }

        public void updateEnabledState() {
            this.enabled = InventoryUtil.hasWorkstationIngredient((Player)Minecraft.m_91087_().f_91074_, this.ingredient);
        }

        public boolean isEnabled() {
            return this.ingredient == null || this.enabled;
        }
    }
}

